/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: MarteCst.java,v 1.4 2007/10/15 09:30:05 fnizou Exp $
 */
package com.cea.nfp.parsers.texteditor.vsldatatypes;

/**
 * 
 * @author T0081227 Francois NIZOU - 31 juil. 07
 * 
 */
public abstract class MarteCst {

	public static final String STEREOTYPE_UNIT = "Unit";

	public abstract class MarteLib {

		public abstract class BasicNfpType {

			public static final String NFP_DATE_TIME = "NFP_DateTime";

			public static final String NFP_DURATION = "NFP_Duration";

			public static final String TUPLE_EXPR_FIELD = "expr";

			public static final String TUPLE_VALUE_FIELD = "value";

			public static final String TUPLE_UNIT_FIELD = "unit";

		}

		public abstract class PrimitivesTypes {

			public static final String DATETIME = "DateTime";

			public static final String NFPEXPRESSION = "NFP_Expression";

			public static final String REAL = "Real";

			public static final String INTERVAL = "Interval";

			public static final String STRING = "String";

			public static final String BOOLEAN = "Boolean";

			public static final String INTEGER = "Integer";

			public static final String UNLIMITEDNATURAL = "UnlimitedNatural";

			public static final String SCIENTIFICREAL = "ScientificReal";

			public static final String VSLEXPRESSION = "VSL_Expression";

		}
	}

	public abstract class VSL {
		public static final String STEREOTYPE_INTERVAL_TYPE = "IntervalType";

		public static final String STEREOTYPE_TUPLE_TYPE = "TupleType";

		public static final String STEREOTYPE_COLLECTION_TYPE = "CollectionType";

		public static final String STEREOTYPE_CHOICE_TYPE = "ChoiceType";

		public static final String VSL_LANGUAGE = "VSL";

		public static final String VSL_INTERVAL_ATTRIB = "intervalAttrib";

		public static final String VSL_COLLECTION_ATTRIB = "collectionAttrib";
		
		public static final String STEREOTYPE_EXPRESSION_CONTEXT = "ExpressionContext";

		public static final String STEREOTYPE_VAR = "Var";
	}

	// Should not be used anymore.
	public static final String VSL_INTERVAL_TYPE = "VSL::IntervalType";

	public static final String VSL_COLLECTION_TYPE = "VSL::CollectionType";

	public static final String VSL_TUPLE_TYPE = "VSL::TupleType";

	public static final String VSL_CHOICE_TYPE = "VSL::ChoiceType";

	public static final String NFP_TYPE = "NFP_Modeling::NfpType";

}
