/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: VSLComplexTypeUtil.java,v 1.2 2007/10/15 09:30:05 fnizou Exp $
 */
package com.cea.nfp.parsers.texteditor.vsldatatypes;

import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Stereotype;

import com.cea.nfp.parsers.texteditor.vsldatatypes.MarteCst.VSL;

/**
 * 
 * @author T0081227 Francois NIZOU - 27 juil. 07
 * 
 */
public class VSLComplexTypeUtil {

	

	public static String getCompositeType(DataType type) {
		EList appliedStereotypes = type.getAppliedStereotypes();
		for (Object object : appliedStereotypes) {
			Stereotype stereotype = (Stereotype) object;
			String s = isStereotypeSubtypeOfComplextype(stereotype);
			if (s != null)
				return s;
		}
		return null;
	}

	public static String isStereotypeSubtypeOfComplextype(Stereotype stereotype) {
		String name = stereotype.getName();
		if (name.equals(VSL.STEREOTYPE_CHOICE_TYPE)
				| name.equals(VSL.STEREOTYPE_COLLECTION_TYPE)
				| name.equals(VSL.STEREOTYPE_TUPLE_TYPE)
				| name.equals(VSL.STEREOTYPE_INTERVAL_TYPE))
			return name;
		else {
			EList generals = stereotype.getGenerals();

			for (Object o : generals) {
				if (o instanceof Stereotype) {
					Stereotype general = (Stereotype) o;
					String s = isStereotypeSubtypeOfComplextype(general);
					if (s != null)
						return s;
				}

			}
		}
		return null;
	}
}
