/*******************************************************************************
 * Copyright (c) 2007 CEA List, THALES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
   
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *     THALES   - Modified code to enhance completion
 *******************************************************************************/

package com.cea.nfp.parsers.texteditor.vsldatatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

import com.cea.nfp.parsers.modelgenerator.IModelFacade;
import com.cea.nfp.parsers.modelgenerator.TypeOrLinkException;
import com.cea.nfp.parsers.modelgenerator.Typer;
import com.cea.nfp.parsers.modelgenerator.VSLGenerator;
import com.cea.nfp.parsers.texteditor.LabelCompletionProcessor;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_BooleanValue_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_Choice_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_Collection_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_DateStr_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_DateTime_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_DayStr_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_DefaultValue_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_EnumerationLiteral_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_Expression_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_Integer_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_Interval_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_Jitter_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_NameExpressionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_NullValue_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_NumberLiteral_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_ObsExprExtended_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_ObsExpr_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_OperationNormalNotation_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_Real_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_StringLiteral_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_TimeExpression_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_TimeStr_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_TupleItem_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_Tuple_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_TypeName_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_UnlimitedNatural_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_VariableName_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_Variable_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_infixeOperator_CompletionProposal;
import com.cea.nfp.parsers.texteditor.completionproposals.VSL_operationRightOperand_CompletionProposal;
import com.cea.nfp.parsers.texteditor.vsldatatypes.MarteCst.VSL;

/**
 * Completion processor for action language. <BR>
 * Main class to process the different completions given by the texteditor to
 * its user
 * 
 * @author Chokri MRAIDHA
 * @author T0081227 Francois NIZOU - 1 aot 07
 * @see org.eclipse.jface.text.templates.TemplateCompletionProcessor
 * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor
 * @see com.cea.actionlanguage.sharedresources.texteditor.IPropertyLabelKeywords
 */

public class VSLLabelCompletionProcessor extends LabelCompletionProcessor
		implements IContext {

	private DataType datatype;

	private DataType subdatatype;

	private IModelFacade facade = null;

	// private Map<String, Boolean> modifiersUsed;

	public VSLLabelCompletionProcessor(DataType datatype, IModelFacade facade) {
		this.datatype = datatype;
		this.facade = facade;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.cea.papyrus.classdiagram.parsers.texteditor.LabelCompletionProcessor#computeCompletionProposals(org.eclipse.jface.text.ITextViewer,
	 *      int)
	 */
	// Modified by THALES
	public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer,
			int documentOffset) {
		String text;
		String completeText;
		String prefix = "";
		String message = null;
		String[] textSplit;

		Collection<ICompletionProposal> result = null;
		int selectionRange = 0;
		int propertyPosition = 0;
		int context = 0;

		try {
			text = viewer.getDocument().get(0, documentOffset);
			completeText = viewer.getDocument().get();

			VSLGenerator generator = new VSLGenerator(facade);

			if (!datatype.getAllAttributes().isEmpty()) {

				// francois, 31 juil. 07:
				// Modified the way to find out if any complex type profile
				// was applied. Because the check with fully qualified
				// stereotype name was too dependant of the implementation of
				// the profile.
				String compositeTypeName = VSLComplexTypeUtil
						.getCompositeType(datatype);
				if (compositeTypeName != null) {
					if (compositeTypeName.equals(VSL.STEREOTYPE_CHOICE_TYPE)) {
						message = generator.isChoiceValid(completeText,
								datatype, documentOffset);
					} else if (compositeTypeName
							.equals(VSL.STEREOTYPE_COLLECTION_TYPE)) {
						message = generator.isCollectionValid(completeText,
								datatype, documentOffset);
					} else if (compositeTypeName
							.equals(VSL.STEREOTYPE_TUPLE_TYPE)) {
						message = generator.isTupleValid(completeText,
								datatype, documentOffset);
					} else if (compositeTypeName
							.equals(VSL.STEREOTYPE_INTERVAL_TYPE)) {
						message = generator.isIntervalValid(completeText,
								datatype, documentOffset);
					}
				}

				subdatatype = generator.getSubDataType();

			} else {
				message = generator.parseAndValidateProperty(completeText,
						datatype);
				// message = generator.parseAndValidateProperty(text, datatype);
				subdatatype = datatype;
			}

			context = generator.getContext();
			result = computedInfixeOperationProposal(text, viewer, context,
					documentOffset, selectionRange);
			if (result != null)
				result.addAll(computeCompletions(viewer, context,
						documentOffset, selectionRange));
			else
				result = computeCompletions(viewer, context,
						documentOffset, selectionRange);
			// francois 30 july 2007. Commented this line to avoid unused double
			// completion
			// computation.
			// if (message != null) {
			// prefix = getPrefix(viewer, documentOffset);
			// result = computeCompletions(viewer, context, documentOffset,
			// selectionRange);
			// }
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
		return result.toArray(new ICompletionProposal[] {});
	}

	/**
	 * compute possible infixe operator or operande.
	 * 
	 * @param text
	 * @param viewer
	 * @param context
	 * @param documentOffset
	 * @param selectionRange
	 * @return
	 */
	// Added by THALES
	private Collection<ICompletionProposal> computedInfixeOperationProposal(
			String text, ITextViewer viewer, int context, int documentOffset,
			int selectionRange) {
		VSLGenerator generator = new VSLGenerator(facade);
		DataType exprType = UMLFactory.eINSTANCE.createDataType();
		exprType.setName("VSL_Expression");
		String message = generator.parseAndValidateTypedExpression(text,
				exprType);
		Collection<ICompletionProposal> results = null;
		ValueSpecification vsl = generator.getVsl();

		if (message == null || message.length() == 0) {
			try {
				ArrayList<DataType> datatype = Typer.type(vsl, facade);
				for (DataType type : datatype) {
					VSL_infixeOperator_CompletionProposal completion = new VSL_infixeOperator_CompletionProposal(
							type, facade);
					if (results == null)
						results = completion.generateCompletionProposals(
								documentOffset, selectionRange, "");
					else
						results.addAll(completion.generateCompletionProposals(
								documentOffset, selectionRange, ""));
				}
			} catch (TypeOrLinkException e) {
			}

		} else {
			int i = -1;
			i = text.lastIndexOf("==");
			i = Math.max(i, text.lastIndexOf(">="));
			i = Math.max(i, text.lastIndexOf("<="));
			i = Math.max(i, text.lastIndexOf("<"));
			i = Math.max(i, text.lastIndexOf(">"));
			i = Math.max(i, text.lastIndexOf("+"));
			i = Math.max(i, text.lastIndexOf("="));
			i = Math.max(i, text.lastIndexOf("-"));
			i = Math.max(i, text.lastIndexOf("/"));
			i = Math.max(i, text.lastIndexOf("%"));

			if (i != -1) {
				message = generator.parseAndValidateTypedExpression(text
						.substring(0, i), exprType);
				if (message == null || message.length() == 0) {
					vsl = generator.getVsl();
					if (vsl == null)
						return new ArrayList<ICompletionProposal>();
					ArrayList<DataType> datatype;
					try {
						datatype = Typer.type(vsl, facade);
						for (DataType type : datatype) {
							VSL_operationRightOperand_CompletionProposal completion = new VSL_operationRightOperand_CompletionProposal(
									text.substring(i, text.length()).trim(),
									type, facade, viewer);
							if (results == null)
								results = completion
										.generateCompletionProposals(
												documentOffset, selectionRange,
												"");
							else
								results.addAll(completion
										.generateCompletionProposals(
												documentOffset, selectionRange,
												""));
						}
					} catch (TypeOrLinkException e) {
					}
				}
			}
		}

		return results;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.cea.papyrus.classdiagram.parsers.texteditor.LabelCompletionProcessor#computeCompletions(org.eclipse.jface.text.ITextViewer,
	 *      int, int, int)
	 */
	// Modified by THALES
	public Collection<ICompletionProposal> computeCompletions(
			ITextViewer viewer, int context, int documentOffset,
			int selectionRange) {
		Vector<ICompletionProposal> v = new Vector<ICompletionProposal>();

		String prefix = getPrefix(viewer, documentOffset);

		// test if that might be an operation call expression in normal notation
		if (prefix.lastIndexOf(".") != -1
				&& prefix.charAt(prefix.lastIndexOf(".") - 1) != '.') {
			VSL_OperationNormalNotation_CompletionProposal operationNormalNotationCompletion = new VSL_OperationNormalNotation_CompletionProposal(
					facade);
			v.addAll(operationNormalNotationCompletion
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
		}

		switch (context) {

		// NAME Expression: commented, we always do that.
		// case IContext.NAME_EXPRESSION:
		// VSL_NameExpressionProposal nameExpressionCompletion = new
		// VSL_NameExpressionProposal(
		// facade);
		// v.addAll(nameExpressionCompletion.generateCompletionProposals(
		// documentOffset, selectionRange, prefix));
		// break;
		// Obs expression like: obs[1] when cond
		case IContext.SINGLE_OBS_EXPR:
			VSL_ObsExpr_CompletionProposal obsProposal = new VSL_ObsExpr_CompletionProposal();
			v.addAll(obsProposal.generateCompletionProposals(documentOffset,
					selectionRange, viewer.getDocument().get()));
			break;
		case IContext.OBS_EXPRESSION:
		case IContext.INSTANT_EXPR:
		case IContext.DURATION_EXPR:
			VSL_ObsExprExtended_CompletionProposal obsExtProposal = new VSL_ObsExprExtended_CompletionProposal(
					facade);
			v.addAll(obsExtProposal.generateCompletionProposals(documentOffset,
					selectionRange, viewer.getDocument().get()));
			break;
		case IContext.JITTER_EXPR:
			VSL_Jitter_CompletionProposal jitterProposal = new VSL_Jitter_CompletionProposal();
			v.addAll(jitterProposal.generateCompletionProposals(documentOffset,
					selectionRange, viewer.getDocument().get()));
			break;
		// ENUMERATION
		case IContext.ENUMERATION:
			VSL_EnumerationLiteral_CompletionProposal enumerationCompletion = new VSL_EnumerationLiteral_CompletionProposal();
			enumerationCompletion.setDataType(subdatatype);
			v.addAll(enumerationCompletion.generateCompletionProposals(
					documentOffset, selectionRange, prefix));
			break;

		// BOOLEAN: true, false
		case IContext.BOOLEAN_LITERAL:
			v.addAll(new VSL_BooleanValue_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;
		// STRING:
		case IContext.STRING_LITERAL:
			v.addAll(new VSL_StringLiteral_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;
		// REAL:
		case IContext.REAL_LITERAL:
			v.addAll(new VSL_Real_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;
		// INTEGER:
		case IContext.INTEGER_LITERAL:
			v.addAll(new VSL_Integer_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;
		// UNLIMITED NATURAL:
		case IContext.UNLIMITED_LITERAL:
			v.addAll(new VSL_UnlimitedNatural_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;

		// DATETIME: date, time, day
		case IContext.DATETIME_LITERAL:
			v.addAll(new VSL_TimeStr_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_DateStr_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_DayStr_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;

		// DATETIME SECOND: dateStr
		case IContext.SECOND:
			v.addAll(new VSL_DateStr_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;
		case IContext.CENTISEC:
			v.addAll(new VSL_DateStr_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;
		case IContext.DATE_STR:
			v.addAll(new VSL_DayStr_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;

		// NFP_VALUE_SPECIFICATION: expression, literal, interval, variable,
		// tuple
		case IContext.NFP_VALUE_SPECIFICATION:
			v.addAll(new VSL_Expression_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_OperationNormalNotation_CompletionProposal(facade)
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_NullValue_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_DefaultValue_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_BooleanValue_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_StringLiteral_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_Real_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_Integer_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_UnlimitedNatural_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_DateTime_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			// v.addAll(new
			// VSL_Interval_CompletionProposal().generateCompletionProposals(documentOffset,
			// selectionRange, prefix));
			v.addAll(new VSL_Variable_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;

		case IContext.TUPLE:
			VSL_Tuple_CompletionProposal tupleCompletion = new VSL_Tuple_CompletionProposal();

			tupleCompletion.setDataType(datatype);

			v.addAll(tupleCompletion.generateCompletionProposals(
					documentOffset, selectionRange, prefix));
			break;

		// francois july 30 2007 - Completion on tuple item field name
		case IContext.TUPLEITEM:
			VSL_TupleItem_CompletionProposal tupleItemCompletion = new VSL_TupleItem_CompletionProposal();
			tupleItemCompletion.setDataType(datatype);
			v
					.addAll(tupleItemCompletion.generateCompletionProposals(
							documentOffset, selectionRange, viewer
									.getDocument().get()));
			break;
		// INTERVAL
		case IContext.INTERVAL:
			v.addAll(new VSL_Interval_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			// v.addAll(new
			// NameCompletionProposal().generateCompletionProposals(documentOffset,
			// selectionRange, prefix));
			break;

		case IContext.INTERVAL_BOUND:
			v.addAll(new VSL_NumberLiteral_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_Tuple_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_Choice_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_Expression_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;

		// COLLECTION
		case IContext.COLLECTION:
			v.addAll(new VSL_Collection_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;

		// CHOICE
		case IContext.CHOICE:
			VSL_Choice_CompletionProposal choiceCompletion = new VSL_Choice_CompletionProposal();

			choiceCompletion.setDataType(datatype);

			v.addAll(choiceCompletion.generateCompletionProposals(
					documentOffset, selectionRange, prefix));
			break;

		// MIN: nullValue, defaultValue, booleanValue, dateTime, numberLiteral,
		// STRING_LITERAL, variable, interval
		case IContext.MIN:
			v.addAll(new VSL_Variable_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_Integer_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_Real_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_StringLiteral_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_DateTime_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			// v.addAll(new
			// VSL_Interval_CompletionProposal().generateCompletionProposals(documentOffset,
			// selectionRange, prefix));
			break;

		// MAX: dateTime, numberLiteral, STRING_LITERAL, variable, interval
		case IContext.MAX:
			v.addAll(new VSL_Variable_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_Integer_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_Real_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_StringLiteral_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_DateTime_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;

		case IContext.EXPRESSION:
			v.addAll(new VSL_Expression_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_TimeExpression_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;

		case IContext.TIME_EXPR:
			v.addAll(new VSL_TimeExpression_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;

		case IContext.VARIABLE_NAME:
			v.addAll(new VSL_VariableName_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			break;

		case IContext.TYPE_NAME:
			v.addAll(new VSL_TypeName_CompletionProposal(facade)
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			return v;

		default:
			v.addAll(new VSL_Expression_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_NullValue_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_DefaultValue_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_BooleanValue_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_StringLiteral_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_Real_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_Integer_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_UnlimitedNatural_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			v.addAll(new VSL_DateTime_CompletionProposal()
					.generateCompletionProposals(documentOffset,
							selectionRange, prefix));
			// System.err.println(context);
			break;

		}

		// Display Expression assist anyway
		v.addAll(new VSL_Expression_CompletionProposal()
				.generateCompletionProposals(documentOffset, selectionRange,
						prefix));
		v.addAll(new VSL_TimeExpression_CompletionProposal()
				.generateCompletionProposals(documentOffset, selectionRange,
						prefix));

		// If the prefix as some letter in, we try to display name completion
		// anyway.
		if (prefix.trim().length() > 0) {
			VSL_NameExpressionProposal nameExpressionCompletion = new VSL_NameExpressionProposal(
					facade);
			v.addAll(nameExpressionCompletion.generateCompletionProposals(
					documentOffset, selectionRange, prefix));
		}

		return v;
	}
	

}