/*******************************************************************************
 * Copyright (c) 2007 CEA List.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *******************************************************************************/

package com.cea.nfp.parsers.texteditor.vsldatatypes;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.OpaqueExpression;

import com.cea.nfp.parsers.modelgenerator.IModelFacade;

/**
 * This class bundles the configuration space of the action language source
 * viewer. Instances of this class are passed to the configure method of
 * <code>SourceViewer</code>.
 * 
 * @author Remi SCHNEKENBURGER
 * @see org.eclipse.jface.text.source.SourceViewerConfiguration
 */
public class VSLLabelSourceViewerConfiguration extends
		SourceViewerConfiguration {

	// private Property property;
	private OpaqueExpression opaqueExpression;

	private IModelFacade facade= null;
	
	private DataType datatype;

	public VSLLabelSourceViewerConfiguration(DataType datatype, IModelFacade facade) {
		// this.opaqueExpression = opaqueExpression;
		this.datatype = datatype;
		this.facade = facade;
	}

	static class SingleTokenScanner extends BufferedRuleBasedScanner {
		public SingleTokenScanner(TextAttribute attribute) {
			setDefaultReturnToken(new Token(attribute));
		}
	};

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.text.source.SourceViewerConfiguration#getPresentationReconciler(org.eclipse.jface.text.source.ISourceViewer)
	 */
	public IPresentationReconciler getPresentationReconciler(
			ISourceViewer sourceViewer) {
		PresentationReconciler reconciler = new PresentationReconciler();

		// creating damager/repairer for single line comments
		Color colorString = VSLLabelColorProvider.getDefault().getColor(
				IVSLLabelColorConstants.STRING);
		DefaultDamagerRepairer dr = new DefaultDamagerRepairer(
				new SingleTokenScanner(new TextAttribute(colorString)));

		reconciler.setDamager(dr,
				VSLLabelPartitionScanner.PROPERTY_MODIFIERS_STRING);
		reconciler.setRepairer(dr,
				VSLLabelPartitionScanner.PROPERTY_MODIFIERS_STRING);

		// creating damager/repairer for other zones (action language zone)
		dr = new DefaultDamagerRepairer(new VSLLabelScanner());
		reconciler.setDamager(dr, IDocument.DEFAULT_CONTENT_TYPE);
		reconciler.setRepairer(dr, IDocument.DEFAULT_CONTENT_TYPE);

		return reconciler;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.text.source.SourceViewerConfiguration#getContentAssistant(org.eclipse.jface.text.source.ISourceViewer)
	 */
	public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
		ContentAssistant assistant = new ContentAssistant();

		IContentAssistProcessor processor = new VSLLabelCompletionProcessor(
				datatype, facade);
		assistant.setContentAssistProcessor(processor,
				IDocument.DEFAULT_CONTENT_TYPE);

		// IInformationControlCreator
		assistant
				.setInformationControlCreator(getInformationControlCreator(sourceViewer));

		assistant.enableAutoActivation(true);
		assistant.setAutoActivationDelay(500);

		return assistant;
	}
}