/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: DatatypeCollection.java,v 1.2 2007/10/15 09:30:05 fnizou Exp $
 */

package com.cea.nfp.parsers.uml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Property;

import com.cea.nfp.parsers.texteditor.vsldatatypes.VSLComplexTypeUtil;
import com.cea.nfp.parsers.texteditor.vsldatatypes.MarteCst.VSL;

/**
 * This class is used to compute model access for Datatypes. Datatypes are
 * computed once only from model and libs. Libs like java, uml, xsd .. are
 * ignored.
 * 
 * @author T0081227 Francois NIZOU - 20 aot 07
 * 
 */
public class DatatypeCollection {

	protected HashMap<String, ArrayList<DataType>> datatypes = null;

	protected ArrayList<DataType> flatDatatypes = null;

	protected Model model;

	protected List libraryDescriptors;

	/**
	 * 
	 * @param libraryDescriptors
	 */
	public DatatypeCollection(List libraryDescriptors, Model model) {

		this.model = model;
		this.libraryDescriptors = libraryDescriptors;
	}

	/**
	 * @param libraryDescriptors
	 * @param model
	 */
	private void init() {
		datatypes = new HashMap<String, ArrayList<DataType>>();
		flatDatatypes = new ArrayList<DataType>();

		for (Object object : libraryDescriptors) {
			Model library = (Model) object;
			String libName = library.getName();
			if (libName.equals("RoseAnalysisDatatypes")
					|| libName.equals("RoseCppDatatypes")
					|| libName.equals("RoseJavaDatatypes")
					|| libName.equals("XSDDataTypes")
					|| libName.equals("UMLPrimitiveTypes")
					|| libName.equals("EcorePrimitiveTypes")
					|| libName.equals("JavaPrimitiveTypes"))
				continue;
			EList allOwnedElements = library.allOwnedElements();
			for (Object object2 : allOwnedElements) {
				if (object2 instanceof DataType) {
					DataType dataType = (DataType) object2;
					flatDatatypes.add(dataType);
					String name = dataType.getName();
					if (!datatypes.containsKey(name))
						datatypes.put(name, new ArrayList<DataType>());
					datatypes.get(name).add(dataType);
				}
			}
		}

		EList allOwnedElements = model.allOwnedElements();
		for (Object object : allOwnedElements) {
			if (object instanceof DataType) {
				DataType dataType = (DataType) object;
				flatDatatypes.add(dataType);
				String name = dataType.getName();
				if (!datatypes.containsKey(name))
					datatypes.put(name, new ArrayList<DataType>());
				datatypes.get(name).add(dataType);
			}
		}
	}

	/**
	 * 
	 * @return
	 */
	public ArrayList<DataType> getAllDatatypes() {
		if (flatDatatypes == null)
			init();
		return flatDatatypes;
	}

	/**
	 * 
	 * @param name
	 * @return
	 */
	public ArrayList<DataType> getDatatypesByName(String name) {
		if (datatypes == null)
			init();
		if (datatypes.containsKey(name))
			return datatypes.get(name);
		else
			return new ArrayList<DataType>();
	}

	/**
	 * 
	 * @param name
	 * @return
	 */
	public ArrayList<DataType> getDatatypesStartWith(String name) {
		if (datatypes == null)
			init();

		Set<String> keySet = datatypes.keySet();
		ArrayList<DataType> result = new ArrayList<DataType>();
		for (Iterator iter = keySet.iterator(); iter.hasNext();) {
			String key = (String) iter.next();
			if (key.startsWith(name))
				result.addAll(datatypes.get(key));
		}
		return result;
	}

	public ArrayList<DataType> findTupleByItemNames(
			ArrayList<String> tupleItemNames) {
		ArrayList<DataType> datatypes = getAllDatatypes();
		ArrayList<DataType> matchingDatatype = new ArrayList<DataType>();
		for (DataType datatype : datatypes) {
			String compositeTypeName = VSLComplexTypeUtil
					.getCompositeType(datatype);
			if (compositeTypeName != null
					&& compositeTypeName.equals(VSL.STEREOTYPE_TUPLE_TYPE)) {
				EList allAttributes = datatype.getAllAttributes();
				ArrayList<String> datatypeItemNames = new ArrayList<String>();
				for (Object object : allAttributes) {
					datatypeItemNames.add(((Property) object).getName());
				}

				if (tupleItemNames.size() != datatypeItemNames.size())
					continue;
				boolean isOk = true;
				for (String itemsName : tupleItemNames) {
					if (!datatypeItemNames.contains(itemsName)) {
						isOk = false;
						break;
					}
				}
				if (isOk)
					matchingDatatype.add(datatype);
			}
		}
		return matchingDatatype;
	}

	public DataType getChoice(String chosenAlternative, DataType valueType) {
		ArrayList<DataType> datatypes = getAllDatatypes();
		for (DataType dataType : datatypes) {
			String compositeTypeName = VSLComplexTypeUtil
					.getCompositeType(dataType);
			if (compositeTypeName != null
					&& compositeTypeName.equals(VSL.STEREOTYPE_CHOICE_TYPE)) {
				EList atttributes = dataType.getAllAttributes();
				for (Object object : atttributes) {
					Property prop = (Property) object;
					if (prop.getName().equals(chosenAlternative)
							&& prop.getType().getName().equals(
									valueType.getName()))
						return dataType;
				}
			}
		}

		return null;
	}
}
