/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: PropertyCollection.java,v 1.5 2007/10/24 07:05:26 fnizou Exp $
 */
package com.cea.nfp.parsers.uml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

import com.cea.nfp.parsers.modelgenerator.IModelFacade;

/**
 * 
 * @author T0081227 Francois NIZOU - 4 sept. 07
 * 
 * 
 */
public class PropertyCollection {

	protected HashMap<String, ArrayList<Property>> properties = null;

	protected ArrayList<Property> flatProperties = null;

	protected Model model;

	protected IModelFacade facade;

	public PropertyCollection(Model model, IModelFacade facade) {
		this.model = model;
		this.facade = facade;
	}

	/**
	 * @param model
	 * @param facade
	 */
	private void init() {
		properties = new HashMap<String, ArrayList<Property>>();
		flatProperties = new ArrayList<Property>();

		ArrayList<Resource> ressources = new ArrayList<Resource>();
		ressources.add(model.eResource());

		Collection result = new ArrayList<Property>();

		EList allOwnedElements = model.allOwnedElements();
		for (Object object : allOwnedElements) {
			if (object instanceof Property)
				result.add(object);
		}

		for (Object object : result) {
			Property property = (Property) object;

			if (isVar(property))
				continue;
				
			Type type = facade.typeof(property);
			if (!(type instanceof DataType))
				continue;
			String name = property.getName();
			String qName = getFQN(property);
			if (!properties.containsKey(name))
				properties.put(name, new ArrayList<Property>());
			if (!properties.containsKey(qName))
				properties.put(qName, new ArrayList<Property>());

			properties.get(name).add(property);
			properties.get(qName).add(property);

			flatProperties.add(property);

		}
	}

	ArrayList<Property> getProperties() {
		if (flatProperties == null)
			init();
		return flatProperties;
	}

	ArrayList<Property> getPropertiesStartWith(String prefix) {
		if (properties == null)
			init();

		ArrayList<Property> result = new ArrayList<Property>();
		Set<String> keySet = properties.keySet();
		for (String key : keySet) {
			if (key.startsWith(prefix)) {
				ArrayList<Property> props = properties.get(key);
				for (Property property : props) {
					if (property.getName().equals(key)) { // not fqn
						if (getFQN(property).equals(
								facade.getCurrentContextName() + "."
										+ equals(key)))
							result.add(property);
					} else {
						result.add(property);
					}
				}
			}
		}
		return result;
	}

	ArrayList<Property> getpropertiesByName(String namespace, String name) {
		if (properties == null)
			init();

		String fqn = (namespace == null || namespace.length() == 0) ? facade
				.getCurrentContextName()
				+ "." + name : namespace + "." + name;
		if (properties.containsKey(fqn))
			return properties.get(fqn);
		else
			return null;
	}

	private String getFQN(Property property) {
		NamedElement ne = property;
		String qName = property.getName();
		while (!(ne.getNamespace() instanceof Model)
				&& !(ne.getNamespace() == null)) {
			ne = ne.getNamespace();
			qName = ne.getName() + "." + qName;
		}

		return qName;
	}

	public static boolean isVar(Property prop) {
		EList appliedStereotypes = prop.getAppliedStereotypes();
		for (Object object : appliedStereotypes) {
			Stereotype stereotype = (Stereotype) object;
			if (stereotype.getName().equals("Var"))
				return true;
		}
		return false;
	}
}
