/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: EclipseUMLResourceFacade.java,v 1.2 2007/10/15 09:30:45 fnizou Exp $
 */
package com.cea.nfp.popup.actions;

import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.OpaqueExpression;

import com.cea.nfp.parsers.modelgenerator.VSLResourceFacade;
import com.cea.nfp.parsers.texteditor.vsldatatypes.MarteCst.VSL;

/**
 * 
 * @author T0081227 Francois NIZOU - 27 juil. 07
 * 
 */
public class EclipseUMLResourceFacade implements VSLResourceFacade {

	private OpaqueExpression opaqueExpression;

	private DataType datatype;

	private int indexBody = 0;

	public EclipseUMLResourceFacade(OpaqueExpression opaqueExpression,
			DataType datatype) {

		this.opaqueExpression = opaqueExpression;
		this.datatype = datatype;
	}

	public DataType getExpectedDatatype() {
		return datatype;
	}

	public String getVSL() {
		for (int i = 0; i < opaqueExpression.getBodies().size(); i++) {
			String language = opaqueExpression.getLanguages().listIterator(i)
					.next().toString();
			if (language.equals(VSL.VSL_LANGUAGE)) {
				indexBody = i;
				return opaqueExpression.getBodies().listIterator(i).next()
						.toString();
			}
		}
		return "";
	}

	public void setVSL(String vsl) {

		if (opaqueExpression.isSetBodies()) {
			opaqueExpression.getBodies().set(indexBody, vsl);
		} else {
			opaqueExpression.getBodies().add(indexBody, vsl);
		}
		if (opaqueExpression.isSetLanguages()) {
			opaqueExpression.getLanguages().set(indexBody,
					VSL.VSL_LANGUAGE);
		} else {
			opaqueExpression.getLanguages().add(indexBody,
					VSL.VSL_LANGUAGE);
		}
	}

}
