/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 * 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: EnterKeyListener.java,v 1.2 2007/10/15 09:59:03 fnizou Exp $
 */

package com.cea.nfp.popup.actions;

/**
 * @author T0081227 Francois NIZOU - 11 oct. 07 
 */
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;

public class EnterKeyListener implements VerifyKeyListener {

	VSLLabelEditorDialog dlg;

	public EnterKeyListener(VSLLabelEditorDialog dlg) {
		super();
		this.dlg = dlg;
	}

	public void verifyKey(VerifyEvent event) {
		if (event.character == SWT.CR) {
			String value = dlg.getSourceViewer().getDocument().get();
			String msg = dlg.getValidator().isValid(value);
			if (msg == null
					|| msg.length() == 0) {
				dlg.buttonPressed(IDialogConstants.OK_ID);
			}
		}
		
	}

}
