/*******************************************************************************
 * Copyright (c) 2007 CEA List, THALES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Eclipse Public License for more details.
 *
 * Contributors:
 *     CEA List - initial API and implementation
 *     THALES   - Modified the way the code access the model
 *******************************************************************************/

/**
 * @author T0081227 NIZOU Francois - 6 july 2007
 */
package com.cea.nfp.popup.actions;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.uml2.uml.DataType;

import com.cea.nfp.parsers.modelgenerator.IModelFacade;
import com.cea.nfp.parsers.modelgenerator.VSLGenerator;
import com.cea.nfp.parsers.texteditor.vsldatatypes.VSLComplexTypeUtil;
import com.cea.nfp.parsers.texteditor.vsldatatypes.MarteCst.VSL;

/**
 * @author RS211865 Validator for Property Labels
 * @see org.eclipse.jface.dialogs.InputDialog
 */
public class VSLLabelValidator implements IInputValidator {

	private DataType datatype;

	private IModelFacade facade;

	// I've removed as much as possible access on the model when
	// it was not needed.
	// The datatype computation was done twice and was unnecessary.
	// It does impact VSLGenerator

	// public TVLLabelValidator(Property property) {
	// super();
	// setProperty(property);
	// }
	// Modified by THALES:
	public VSLLabelValidator(DataType datatype, IModelFacade facade) {
		super();
		this.facade = facade;
		this.datatype = datatype;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.IInputValidator#isValid(java.lang.String)
	 */
	// Modified by THALES
	public String isValid(String newText) {
		String message = "";

		if (newText == null || newText.length() == 0)
			return null;

		VSLGenerator generator = new VSLGenerator(facade);

		// francois, july 9 2007: modified the way complex type were handled
		// (i.e only tuple was).
		String complextypeName = VSLComplexTypeUtil.getCompositeType(datatype);
		if (complextypeName == null)
			message = generator.parseAndValidateProperty(newText, datatype);
		else {
			if (complextypeName.equals(VSL.STEREOTYPE_CHOICE_TYPE))
				message = generator.isChoiceValid(newText, datatype, -1);
			if (complextypeName.equals(VSL.STEREOTYPE_COLLECTION_TYPE))
				message = generator.isCollectionValid(newText, datatype, -1);
			if (complextypeName.equals(VSL.STEREOTYPE_TUPLE_TYPE))
				message = generator.isTupleValid(newText, datatype, -1);
			if (complextypeName.equals(VSL.STEREOTYPE_INTERVAL_TYPE))
				message = generator.isIntervalValid(newText, datatype, -1);
		}

		return message;

	}

}
