/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>

 *
 * $Id: PropertyResourceFacade.java,v 1.2 2007/10/15 09:30:45 fnizou Exp $
 */
package model;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;

import com.cea.nfp.parsers.modelgenerator.VSLResourceFacade;

/**
 * 
 * @author T0081227 Francois NIZOU - 3 sept. 07
 * 
 */
public class PropertyResourceFacade implements VSLResourceFacade {

	private Property property;

	private DataType type;

	public PropertyResourceFacade(Property property, DataType type) {
		this.property = property;
		if (property.getDefault() == null)
			property.setDefault("");
		this.type = type;
	}

	public DataType getExpectedDatatype() {
		return type;
	}

	public String getVSL() {
		return property.getDefault();
	}

	public void setVSL(String vsl) {
		String old = property.getDefault();
		property.setDefault(vsl);

		property.eNotify(new NotificationImpl(Notification.SET, old, vsl));
	}

}
