/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: PropertyCollection.java,v 1.5 2007/10/24 07:06:56 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.facade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

import com.cea.nfp.parsers.modelgenerator.IModelFacade;
import com.ibm.xtools.emf.index.search.IIndexSearchManager;
import com.ibm.xtools.emf.index.search.IndexContext;

/**
 * 
 * @author T0081227 Francois NIZOU - 20 aot 07
 * 
 * 
 */
public class PropertyCollection {

	protected HashMap<String, ArrayList<Property>> properties = null;

	protected ArrayList<Property> flatProperties = null;

	protected Model model;

	protected IModelFacade facade;

	public PropertyCollection(Model model, IModelFacade facade) {
		this.model = model;
		this.facade = facade;
	}

	/**
	 * @param model
	 * @param facade
	 */
	private void init() {
		properties = new HashMap<String, ArrayList<Property>>();
		flatProperties = new ArrayList<Property>();

		ArrayList<Resource> ressources = new ArrayList<Resource>();
		ressources.add(model.eResource());

		IndexContext indexContext = new IndexContext(model.eResource()
				.getResourceSet(), ressources);
		indexContext.getOptions().put(IndexContext.RESOLVE_PROXIES,
				Boolean.TRUE);
		Collection result = null;

		try {
			result = IIndexSearchManager.INSTANCE.findEObjects(indexContext,
					"*", false, null, UMLPackage.eINSTANCE.getProperty(),
					new NullProgressMonitor());
		} catch (Exception e) {

		}

		for (Object object : result) {
			Property property = (Property) object;

			if (property.getAppliedStereotype("VSL::Var") != null)
				continue;

			Type type = facade.typeof(property);
			if (!(type instanceof DataType))
				continue;
			String name = property.getName();
			String qName = getFQN(property);
			if (!properties.containsKey(name))
				properties.put(name, new ArrayList<Property>());
			if (!properties.containsKey(qName))
				properties.put(qName, new ArrayList<Property>());

			properties.get(name).add(property);
			properties.get(qName).add(property);

			flatProperties.add(property);

		}
	}

	ArrayList<Property> getProperties() {
		if (flatProperties == null)
			init();
		return flatProperties;
	}

	ArrayList<Property> getPropertiesStartWith(String prefix) {
		if (properties == null)
			init();

		ArrayList<Property> result = new ArrayList<Property>();
		Set<String> keySet = properties.keySet();
		for (String key : keySet) {
			if (key.startsWith(prefix)) {
				ArrayList<Property> props = properties.get(key);
				for (Property property : props) {
					if (property.getName().startsWith(key)) { // not fqn
						if (getFQN(property).equals(
								facade.getCurrentContextName() + "." + key))
							result.add(property);
					} else {
						result.add(property);
					}
				}
			}
		}
		return result;
	}

	ArrayList<Property> getpropertiesByName(String namespace, String name) {
		if (properties == null)
			init();

		String fqn = (namespace == null || namespace.length() == 0) ? facade
				.getCurrentContextName()
				+ "." + name : namespace + "." + name;
		if (properties.containsKey(fqn))
			return properties.get(fqn);
		else
			return null;
	}

	private String getFQN(Property property) {
		String qName = property.getQualifiedName().replaceAll("::", ".");
		qName = qName.substring(qName.indexOf(".") + 1);
		return qName;
	}
}
