/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: RSAModelFacade.java,v 1.12 2007/10/15 09:57:11 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.facade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Observation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;

import VSL.Variable;

import com.cea.nfp.parsers.modelgenerator.IModelFacade;
import com.cea.nfp.parsers.texteditor.vsldatatypes.MarteCst.VSL;
import com.ibm.xtools.emf.index.search.IIndexSearchManager;
import com.ibm.xtools.emf.index.search.IndexContext;
import com.ibm.xtools.uml.msl.internal.util.UML2ResourceManager;

/**
 * The model facade for RSA. It's mostly alike UMLFacade but add tagged value
 * for variable search. Also, this facade is meant for the MARTE profile for
 * RSA. Because of the limitation of RSA for profile, What should be datatype
 * are actualy Class. Hence typeof work a bit differently.
 * 
 * @author T0081227 Francois NIZOU - 6 aot 07
 * 
 */
public class RSAModelFacade implements IModelFacade {

	protected static Hashtable<String, DataType> marteLibDatatype = null;

	protected DatatypeCollection datatypesCollection;

	protected ObservationCollection observationCollection;

	protected PropertyCollection propertyCollection;

	protected VariablesCollection variablesCollection;

	private Model model;

	private Element vslDefiningElement;

	public RSAModelFacade(Model model, Element vslDefiningElement) {
		this.model = model;
		this.vslDefiningElement = vslDefiningElement;
		this.datatypesCollection = new DatatypeCollection(UML2ResourceManager
				.getLibraryDescriptors(), model);
		this.observationCollection = new ObservationCollection(model);
		this.propertyCollection = new PropertyCollection(model, this);
		this.variablesCollection = new VariablesCollection(model, this,
				vslDefiningElement);
	}

	public DataType typeof(TypedElement typedElement) {

		Type type = typedElement.getType();
		if (type == null)
			return null;

		if (type instanceof DataType)
			return (DataType) type;
		else {
			String name = type.getName();
			ArrayList<DataType> datatypesByName = datatypesCollection
					.getDatatypesByName(name);
			if (datatypesByName == null || datatypesByName.size() == 0)
				return null;
			else
				return datatypesByName.get(0);
		}
	}

	public ArrayList<DataType> getDataTypes() {
		return datatypesCollection.getAllDatatypes();
	}

	public ArrayList<DataType> getDataTypesByName(String name) {
		return datatypesCollection.getDatatypesByName(name);
	}

	public ArrayList<DataType> getDataTypesStartWith(String startwith) {
		return datatypesCollection.getDatatypesStartWith(startwith);
	}

	public ArrayList<Observation> getObservations() {
		return observationCollection.getObservations();
	}

	public ArrayList<Observation> getObservationsByName(String name) {
		return observationCollection.getObservationsByName(name);
	}

	public ArrayList<Observation> getObservationsStartWith(String prefix) {
		return observationCollection.getObservationsStartWith(prefix);
	}

	public ArrayList<Property> getProperties() {
		return propertyCollection.getProperties();
	}

	public ArrayList<Property> getpropertiesByName(String namespace, String name) {
		return propertyCollection.getpropertiesByName(namespace, name);
	}

	public ArrayList<Property> getPropertiesStartWith(String prefix) {
		return propertyCollection.getPropertiesStartWith(prefix);
	}

	/**
	 * 
	 * @return All the VSL variables of the Model.
	 */
	public ArrayList<Variable> getVariables() {
		return variablesCollection.getVariables();
	}

	/**
	 * 
	 * @param prefix
	 * @return all the VSL variables of the Model Starting with startwith
	 */
	public ArrayList<Variable> getVariablesStartWith(String prefix) {
		return variablesCollection.getVariablesStartWith(prefix);
	}

	/**
	 * 
	 * @param namespace
	 * @param name
	 * @return all Variables called namespace.name
	 */
	public ArrayList<Variable> getVariablesByName(String namespace, String name) {
		return variablesCollection.getVariablesByName(namespace, name);
	}

	public ArrayList<EnumerationLiteral> getEnumerationsByName(String name,
			boolean isStartWith) {
		ArrayList<EnumerationLiteral> result = new ArrayList<EnumerationLiteral>();
		ResourceSet resourceSet = model.eResource().getResourceSet();
		// EList resources = resourceSet.getResources();
		ArrayList<Resource> resources = new ArrayList<Resource>();
		resources.add(model.eResource());
		IndexContext indexContext = new IndexContext(resourceSet, resources);
		indexContext.getOptions().put(IndexContext.RESOLVE_PROXIES,
				Boolean.TRUE);
		indexContext.getOptions().put(IndexContext.SEARCH_DEPLOYED_RESOURCES,
				Boolean.TRUE);

		String queryString = (isStartWith) ? name + "*" : name;

		Collection oes = null;
		try {
			oes = IIndexSearchManager.INSTANCE
					.findEObjects(indexContext, queryString, false, null,
							UMLPackage.eINSTANCE.getEnumerationLiteral(),
							new NullProgressMonitor());
			result.addAll(oes);
		} catch (Exception e) {
			return null;
		}

		return result;
	}

	public String getCurrentContextName() {
		Element elt = vslDefiningElement;
		while (elt != null && !(elt instanceof NamedElement)) {
			elt = elt.getOwner();
		}

		if (elt == null)
			return "";

		NamedElement ne = (NamedElement) elt;
		String qName = ne.getNamespace().getQualifiedName().replaceAll("::",
				".");
		qName = qName.substring(qName.indexOf(".") + 1);
		return qName;
	}

	public ArrayList<DataType> findTupleByItemNames(
			ArrayList<String> tupleItemNames) {
		return datatypesCollection.findTupleByItemNames(tupleItemNames);
	}

	public DataType getChoice(String chosenAlternative, DataType valueType) {
		return datatypesCollection.getChoice(chosenAlternative, valueType);
	}

	public String getQualifiedName(NamedElement element) {
		String name = element.getName();
		Element father = (Element) element.getOwner();
		while (father.getOwner() != null) {
			name = ((NamedElement) father).getName() + "." + name;
			father = father.getOwner();
		}
		return name;
	}

	public boolean isLocalProperty(Property property) {
		Element elt = vslDefiningElement;
		NamedElement ne = null;
		while (elt != null && !(elt instanceof NamedElement)) {
			elt = elt.getOwner();
		}

		if (elt == null)
			return false;
		else {
			ne = (NamedElement) elt;
			return (property.getNamespace().equals(ne.getNamespace()));
		}

		// EList ownedElements = vslDefiningElement.getOwnedElements();
		// for (Object object : ownedElements) {
		// if (object instanceof Property) {
		// Property prop = (Property) object;
		// if (prop == property) {
		// return true;
		// }
		// }
		// }
		// return false;
	}

	/**
	 * 
	 * @param owner
	 * @return
	 */
	public String getContextFromElement(Element owner) {
		if (owner instanceof Model)
			return "";
		else if (isStereotypedBy(owner, VSL.STEREOTYPE_EXPRESSION_CONTEXT) != null) {
			return getQualifiedName((NamedElement) owner);
		} else {
			return getContextFromElement(owner.getOwner());
		}
	}

	protected Stereotype isStereotypedBy(Element elt, String stereotypeName) {
		EList appliedStereotypes = elt.getAppliedStereotypes();
		for (Object object : appliedStereotypes) {
			Stereotype s = (Stereotype) object;
			if (s.getName().equals(stereotypeName))
				return s;
		}
		return null;
	}

	public String getCurrentVariableContextName() {
		return getContextFromElement(vslDefiningElement);
	}

}
