/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: RSAResourceFacade.java,v 1.4 2007/10/15 09:57:11 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.facade;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.OpaqueExpression;

import com.cea.nfp.parsers.modelgenerator.VSLResourceFacade;
import com.cea.nfp.parsers.texteditor.vsldatatypes.MarteCst.VSL;
import com.ibm.xtools.modeler.ui.UMLModeler;

/**
 * Implementation of VSLResourceFacade for RSA. The difference is the 
 * use of a transaction for writting the VSL into the model.
 * THis facade is used for Slot & Constraint.
 * @author T0081227 Francois NIZOU - 27 juil. 07
 * 
 */
public class RSAResourceFacade implements VSLResourceFacade {

	private OpaqueExpression opaqueExpression;

	private DataType datatype;

	private int indexBody = 0;

	public RSAResourceFacade(OpaqueExpression opaqueExpression,
			DataType datatype) {

		this.opaqueExpression = opaqueExpression;
		this.datatype = datatype;
	}

	public DataType getExpectedDatatype() {
		return datatype;
	}

	public String getVSL() {
		for (int i = 0; i < opaqueExpression.getBodies().size() && i < opaqueExpression.getLanguages().size(); i++) {
			String language = opaqueExpression.getLanguages().get(i).toString();
			if (language.equals(VSL.VSL_LANGUAGE)) {
				indexBody = i;
				return opaqueExpression.getBodies().get(i).toString();
			}
		}
		return "";
	}

	public void setVSL(final String vsl) {

		try {
			TransactionalEditingDomain editDomain = UMLModeler
					.getEditingDomain();
			editDomain.getCommandStack().execute(
					new RecordingCommand(editDomain) {
						protected void doExecute() {
							if (opaqueExpression.isSetBodies()) {
								opaqueExpression.getBodies()
										.set(indexBody, vsl);
							} else {
								opaqueExpression.getBodies()
										.add(indexBody, vsl);
							}
							if (opaqueExpression.isSetLanguages()) {
								opaqueExpression.getLanguages().set(indexBody,
										VSL.VSL_LANGUAGE);
							} else {
								opaqueExpression.getLanguages().add(indexBody,
										VSL.VSL_LANGUAGE);
							}
						}
					});
		} catch (IllegalStateException e) {
			System.out.println("The operation was interrupted");
		}

	}

}
