/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: StereotypeAttributeFacade.java,v 1.3 2007/10/15 09:57:11 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.facade;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.DataType;

import com.cea.nfp.parsers.modelgenerator.VSLResourceFacade;

/**
 * Implementation of VSLResourceFacade for RSA. This is used for
 * tagged value and meant to be used with MARTE profile for RSA.
 * see {@link StereotypeAttributeFacade#getVSL()} for more detail.
 * @author T0081227 Francois NIZOU - 6 aot 07 
 *
 */
public class StereotypeAttributeFacade implements VSLResourceFacade {

	private EObject eobject;

	private DataType type;

	public StereotypeAttributeFacade(EObject value, DataType type) {
		this.eobject = value;
		this.type = type;
	}

	public DataType getExpectedDatatype() {
		return type;
	}

	/**
	 * In the case of Marte profile for RSA, stereotype attribute that should have
	 * been Datatype are actualy metaClass. The VSL is meant to be stocked in
	 * an attribute value of that class.
	 */
	public String getVSL() {
		EClass clazz = eobject.eClass();
		EStructuralFeature sf = clazz.getEStructuralFeature("value");
		if (sf != null) {
			Object get = eobject.eGet(sf);
			if (get != null)
				return get.toString();
			else 
				return "";
		} else
			return null;
	}

	public void setVSL(String vsl) {
		EClass clazz = eobject.eClass();
		EStructuralFeature sf = clazz.getEStructuralFeature("value");
		eobject.eSet(sf, vsl);
	}

}
