/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 */
package com.thalesgroup.nfp.rsa.facade;

import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

import com.cea.nfp.parsers.modelgenerator.VSLResourceFacade;

public class StereotypePrimitiveTypeFacade implements VSLResourceFacade {

	private Element element;

	private Stereotype stereotype;

	private Property property;

	public StereotypePrimitiveTypeFacade(Element element,
			Stereotype stereotype, Property property) {
		this.element = element;
		this.stereotype = stereotype;
		this.property = property;
	}

	public DataType getExpectedDatatype() {
		return (DataType) property.getType();
	}

	public String getVSL() {
		Object value = element.getValue(stereotype, property.getName());
		if (value == null)
			return "";
		else
			return value.toString();
	}

	public void setVSL(String vsl) {
		String name = property.getName();
		if (name.equals("Integer")) {
			element.setValue(stereotype, property.getName(), Integer
					.parseInt(vsl));
		} else if (name.equals("Boolean")) {
			element.setValue(stereotype, property.getName(), Boolean
					.parseBoolean(vsl));
		} else if (name.equals("UnlimitedNatural")) {
			element.setValue(stereotype, property.getName(), Integer
					.parseInt(vsl));
		} else {
			element.setValue(stereotype, property.getName(), vsl);
		}
	}

}
