/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: Util.java,v 1.5 2007/10/30 08:03:00 sdemathieu Exp $
 */
package com.thalesgroup.nfp.rsa.facade;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

/**
 * This class is an utility class.
 * 
 * @author T0081227 Francois NIZOU - 6 aot 07
 * 
 * 
 */
public class Util {

	/**
	 * Create an object corresponding to an 'instance' of a Class from a
	 * profile.
	 * 
	 * @param e
	 *            The element on wich the profile is applied.
	 * @param stereotype
	 * @param propertyName
	 * @return an object o that can be put in tagged value,
	 *         e.setValue(stereotype, propertyName, o)
	 */
	public static DynamicEObjectImpl createInstance(Element e,
			Stereotype stereotype, String propertyName) {

		EList allAttributes = stereotype.getAllAttributes();

		Property property = null;
		for (Object object : allAttributes) {
			Property prop = (Property) object;
			if (prop.getName().equals(propertyName)) {
				property = prop;
				break;
			}
		}

		EObject eObject = e.getStereotypeApplication(stereotype);
		EClass eClass = eObject.eClass();
		EStructuralFeature eStructuralFeature = null;
		eStructuralFeature = eClass.getEStructuralFeature(property.getName());
		EClassifier type = eStructuralFeature.getEType();

		EClass eType = (EClass) type;

		if (eType instanceof EClass) {
			DynamicEObjectImpl dyn = new DynamicEObjectImpl(eType);
			return dyn;
		} else {
			// Sbastien Demathieu (29/10/07)
			// Updated error message
			System.err.println("An error occured");
			return null;
		}
	}
}
