/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: ConstraintEditionAction.java,v 1.3 2007/10/17 15:29:45 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.popup.actions;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Constraint;

import com.ibm.xtools.uml.ui.diagram.internal.editparts.ConstraintEditPart;
import com.thalesgroup.nfp.rsa.model.RSAModel;

/**
 * 
 * @author T0081227 Francois NIZOU - 1 aot 07
 * 
 */
public class ConstraintEditionAction implements IObjectActionDelegate {

	/**
	 * Constructor for Action1.
	 */
	public ConstraintEditionAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow();
		ISelection selectedElement = activeWorkbenchWindow
				.getSelectionService().getSelection();

		IStructuredSelection structuredSel = (IStructuredSelection) selectedElement;
		ConstraintEditPart part = (ConstraintEditPart) structuredSel
				.getFirstElement();
		Node node = (Node) part.getModel();
		Constraint constraint = (Constraint) node.getElement();

		RSAModel.instance().handleConstraint(constraint);

//		activeWorkbenchWindow.getActivePage().getActiveEditor().doSave(
//				new NullProgressMonitor());
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

}
