/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: MultiValuedPropertyLabelProvider.java,v 1.3 2007/10/15 09:57:11 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.views;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

/**
 * Label provider for MultiValued stereotype attribute 
 * @author T0081227 Francois NIZOU - 6 aot 07 
 *
 */
public class MultiValuedPropertyLabelProvider extends LabelProvider {

	@Override
	public String getText(Object element) {
		MultiValuedPropertyPropertySource desc = (MultiValuedPropertyPropertySource)element;
		Property prop = desc.getProperty();
		Element e = desc.getElement();
		Stereotype stereotype = desc.getStereotype();
		
		EList lst = (EList)e.getValue(stereotype, prop.getName());
		int size = (lst != null)? lst.size(): 0;
		
		String s = prop.getType().getName() + "[" + size + "]";
		return s;
	}

	
	


}
