/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: MultiValuedPropertyPropertySource.java,v 1.3 2007/10/15 09:57:11 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.views;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

/**
 * propertySoruce for a collection of value for stereotype attribute.
 * @author T0081227 Francois NIZOU - 6 aot 07 
 *
 */
public class MultiValuedPropertyPropertySource implements IPropertySource {

	private Element element;

	private Stereotype stereotype;

	private Property property;

	public Element getElement() {
		return element;
	}

	public Property getProperty() {
		return property;
	}

	public Stereotype getStereotype() {
		return stereotype;
	}

	public MultiValuedPropertyPropertySource(Element element,
			Stereotype stereotype, Property property) {
		super();
		this.element = element;
		this.stereotype = stereotype;
		this.property = property;
	}

	public Object getEditableValue() {
		return this;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		EList o = (EList) element.getValue(stereotype, property.getName());
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[o.size()];

		for (int i = 0; i < descriptors.length; i++) {
			VSLDescriptor descr = new VSLDescriptor(i, "[" + i + "]");
			descr.setUp(element, stereotype, property, i);
			descriptors[i] = descr;
		}
		return descriptors;
	}

	public Object getPropertyValue(Object id) {
		EList lst = (EList) element.getValue(stereotype, property.getName());
		Integer i = (Integer) id;

		Object value = lst.get(i);

		if (value instanceof DynamicEObjectImpl) {
			DynamicEObjectImpl dynObj = (DynamicEObjectImpl) value;
			EClass clazz = dynObj.eClass();
			EStructuralFeature sf = clazz.getEStructuralFeature("value");
			if (sf != null)
				return dynObj.eGet(sf);
			else
				return "";
		} else {
			return value;
		}

	}

	public boolean isPropertySet(Object id) {
		// TODO Auto-generated method stub
		return false;
	}

	public void resetPropertyValue(Object id) {
		// TODO Auto-generated method stub

	}

	public void setPropertyValue(Object id, Object value) {
	

	}

}
