/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: StereotypePropertySource.java,v 1.4 2007/11/02 15:13:36 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.views;

import java.util.ArrayList;
import java.util.HashSet;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

import com.thalesgroup.nfp.rsa.facade.RSAModelFacade;

/**
 * 
 * @author T0081227 Francois NIZOU - 6 aot 07
 * 
 */
public class StereotypePropertySource implements IPropertySource {

	private Stereotype stereotype;

	private Element element;

	public StereotypePropertySource(Stereotype stereotype, Element element) {
		super();
		this.stereotype = stereotype;
		this.element = element;
	}

	public Object getEditableValue() {
		// TODO Auto-generated method stub
		return null;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		EList allAttributes = stereotype.getAllAttributes();

		// TODO: faire une vraie recherche
		RSAModelFacade facade = new RSAModelFacade(element.getModel(), element);

		ArrayList<IPropertyDescriptor> propDescriptors = new ArrayList<IPropertyDescriptor>();
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[0];
		HashSet<String> set = new HashSet<String>();

		for (int i = 0; i < allAttributes.size(); i++) {
			Property prop = (Property) allAttributes.get(i);

			if (set.contains(prop.getName()))
				continue;
			else
				set.add(prop.getName());

			if (!prop.getName().startsWith("base_")) {

				if (prop.getUpper() > 1 || prop.getUpper() == -1) {
					if (isvalid(prop, facade)) {
						PropertyDescriptor descr = new PropertyDescriptor(i,
								prop.getName());
						descr
								.setLabelProvider(new MultiValuedPropertyLabelProvider());
						propDescriptors.add(descr);
					}
				} else {
					if (isvalid(prop, facade)) {
						VSLDescriptor descr = new VSLDescriptor(i, prop
								.getName());
						descr.setUp(element, stereotype, prop);
						propDescriptors.add(descr);
					}
				}
			}

		}

		return propDescriptors.toArray(descriptors);
	}

	private boolean isvalid(Property prop, RSAModelFacade facade) {
		// last update 02/11/07
		// removed Enumeration typed property from TreeView.
		Type type = facade.typeof(prop);
		return (type instanceof DataType && !(type instanceof Enumeration));
		// end of last update
	}

	public Object getPropertyValue(Object id) {
		Integer i = (Integer) id;
		EList allAttributes = stereotype.getAllAttributes();
		Property prop = (Property) allAttributes.get(i);
		if (prop.getUpper() > 1 || prop.getUpper() == -1)
			return new MultiValuedPropertyPropertySource(element, stereotype,
					prop);
		else {
			Object value = element.getValue(stereotype, prop.getName());
			if (value instanceof DynamicEObjectImpl) {
				DynamicEObjectImpl dynObj = (DynamicEObjectImpl) value;
				EClass clazz = dynObj.eClass();
				EStructuralFeature sf = clazz.getEStructuralFeature("value");
				if (sf != null)
					return dynObj.eGet(sf);
				else
					return "";
			} else {
				return value;
			}
		}
	}

	public boolean isPropertySet(Object id) {
		// TODO Auto-generated method stub
		return false;
	}

	public void resetPropertyValue(Object id) {
		// TODO Auto-generated method stub

	}

	public void setPropertyValue(Object id, Object value) {
		// TODO Auto-generated method stub

	}

}
