/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: UMLElementSourceProvider.java,v 1.4 2007/10/15 09:57:11 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.views;

import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.impl.EdgeImpl;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.uml2.uml.Element;

import com.ibm.xtools.uml.navigator.ModelServerElement;
import com.ibm.xtools.uml.ui.diagrams.structure.internal.editparts.ConnectorEditPart;

/**
 * provide property source for selected element. The selection might be from 
 * RSA Tree view or graphical view.
 * @author T0081227 Francois NIZOU - 6 aot 07 
 *
 */
public class UMLElementSourceProvider implements IPropertySourceProvider {

	public IPropertySource getPropertySource(Object object) {
		IPropertySource source = null;
		if (object != null) {
			if (object instanceof EditPart) {
				Object model = ((EditPart) object).getModel();
				if (model instanceof Node){
					source = new ElementPropertySource((Element) ((Node)model).getElement());
				} else if (model instanceof EdgeImpl){
					source = new ElementPropertySource((Element) ((EdgeImpl)model).getElement());
				}
			} else if(object instanceof ModelServerElement){
				ModelServerElement modelserverElt = (ModelServerElement)object;
				Element element = (Element)modelserverElt.getElement();
				source = new ElementPropertySource(element);
				
			} else if(object instanceof IPropertySource){
				source = (IPropertySource)object;
			}
		} 
		return source;
	}
		

}
