/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: VSLDescriptor.java,v 1.3 2007/10/15 09:57:11 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.views;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

/**
 * A property descriptor using the VSLCellEditor for VSL on tagged Value.
 * This descriptor might be used for single valeud stereotype property or
 * for any slot in the collection of a multi valued stereotype property.
 * @author T0081227 Francois NIZOU - 6 aot 07 
 *
 */
public class VSLDescriptor extends PropertyDescriptor {

	Element element = null;

	Stereotype stereotype = null;

	Property property = null;

	Integer index = null;

	/**
	 * Description for a single valued stereotype property
	 * element.getValue(stereotype, property).
	 * @param element
	 * @param stereotype
	 * @param property
	 */
	public void setUp(Element element, Stereotype stereotype, Property property) {
		this.element = element;
		this.stereotype = stereotype;
		this.property = property;
	}

	/**
	 * Dexcription for a MultiValued Stereotype property.
	 * element.getValue(element, stereotype).get(index).
	 * @param element
	 * @param stereotype
	 * @param property
	 * @param index
	 */
	public void setUp(Element element, Stereotype stereotype,
			Property property, Integer index) {
		this.element = element;
		this.stereotype = stereotype;
		this.property = property;
		this.index = index;
	}

	public VSLDescriptor(Object id, String displayName) {
		super(id, displayName);
	}

	@Override
	public CellEditor createPropertyEditor(Composite parent) {
		VSLCellEditor editor = new VSLCellEditor(parent);
		editor.setUp(element, stereotype,property, index);
		if (getValidator() != null)
			editor.setValidator(getValidator());
		return editor;
	}

}
