/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: VSLFilter.java,v 1.3 2007/11/02 15:13:36 fnizou Exp $
 */
package com.thalesgroup.nfp.rsa.views;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.notation.impl.ViewImpl;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.uml2.uml.Element;

import com.ibm.xtools.uml.navigator.ModelServerElement;
import com.ibm.xtools.uml.ui.diagram.internal.editparts.UMLLabelEditPart;

/**
 * 
 * @author T0081227 Francois NIZOU - 3 sept. 07
 * 
 */
public class VSLFilter implements IFilter {

	public boolean select(Object toTest) {

		// last update 02/11/07
		// generic code to get UML element from selection. Code below these lines is 
		// not usefull anymore.
		if (toTest instanceof IAdaptable) {
			IAdaptable adaptable = (IAdaptable) toTest;
			Object adapter = adaptable.getAdapter(Element.class);
			if (adapter != null) {
				Element element = (Element) adapter;
				return (element.getAppliedStereotypes().size() > 0);
			}
		}
		// end last update

		Element elt = null;
		if (toTest instanceof ModelServerElement) {
			ModelServerElement modelServerElement = (ModelServerElement) toTest;
			Object element = modelServerElement.getElement();
			if (element instanceof Element)
				elt = (Element) element;
		} else if (toTest instanceof INodeEditPart) {
			INodeEditPart nodeEditPart = (INodeEditPart) toTest;
			Object model = nodeEditPart.getModel();
			if (model instanceof ViewImpl) {
				ViewImpl view = (ViewImpl) model;
				if (view.getElement() instanceof Element)
					elt = (Element) view.getElement();
			}
		} else if (toTest instanceof UMLLabelEditPart) {
			UMLLabelEditPart labelEditPart = (UMLLabelEditPart) toTest;
			Object model = labelEditPart.getModel();
			if (model instanceof ViewImpl) {
				ViewImpl view = (ViewImpl) model;
				if (view.getElement() instanceof Element)
					elt = (Element) view.getElement();
			}
		}
		if (elt != null) {
			return (elt.getAppliedStereotypes().size() > 0);
		} else {
			return false;
		}
	}

}
