/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 *
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 *
 * $Id: AddSendOperationEventAction.java,v 1.3 2007/10/18 15:43:13 fnizou Exp $
 */

package com.thalesgroup.marte.rsa.helper.actions;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.uml2.uml.SendOperationEvent;
import org.eclipse.uml2.uml.UMLFactory;

import com.ibm.xtools.modeler.ui.UMLModeler;
import com.ibm.xtools.uml.navigator.ModelServerElement;

/**
 * This action creates a new instance of SendOperationEvent under the selected UML
 * package.
 * 
 * @author Sbastien Demathieu (Thales Research & Technology)
 * @version 1.0 - 10/08/07
 */
public class AddSendOperationEventAction implements
		IWorkbenchWindowActionDelegate {

	/**
	 * 
	 */
	private static int count = 0;

	/**
	 * The workbench window
	 */
	private IWorkbenchWindow _window;

	/**
	 * The selected UML package
	 */
	private org.eclipse.uml2.uml.Package _package;

	/**
	 * AddSendOperationEventAction default constructor
	 */
	public AddSendOperationEventAction() {
	}

	/**
	 * The action has been activated. The argument of the method represents the
	 * 'real' action sitting in the workbench UI.
	 * 
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action) {

		// Checks if the selection is consistent
		if (_package != null) {

			try {
				// RSA requires any modification to the model to be made within
				// an EMF transaction
				TransactionalEditingDomain editDomain = UMLModeler
						.getEditingDomain();
				editDomain.getCommandStack().execute(
						new RecordingCommand(editDomain) {

							protected void doExecute() {
								// Creates a new SendOperationEvent and adds it
								// to the package. The EMF adapters will handle
								// the rest.
								SendOperationEvent event = UMLFactory.eINSTANCE
										.createSendOperationEvent();
								event.setName("SendOperationEvent0" + count);
								count++;
								_package.getPackagedElements().add(event);
							}
						});
			} catch (IllegalStateException e) {
				System.out.println("The operation was interrupted");
			}
		}

	}

	/**
	 * Selection in the workbench has been changed. We can change the state of
	 * the 'real' action here if we want, but this can only happen after the
	 * delegate has been created.
	 * 
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		IStructuredSelection struct = (IStructuredSelection) selection;

		// Checks if the selection is a UML navigator element
		if (struct.getFirstElement() instanceof ModelServerElement) {
			ModelServerElement server = (ModelServerElement) struct
					.getFirstElement();

			// Access the UML package inside the navigator element
			if (server.getElement() instanceof org.eclipse.uml2.uml.Package) {
				_package = (org.eclipse.uml2.uml.Package) server.getElement();
			} else {
				_package = null;
			}

		}
	}

	/**
	 * We can use this method to dispose of any system resources we previously
	 * allocated.
	 * 
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * We will cache window object in order to be able to provide parent shell
	 * for the message dialog.
	 * 
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		_window = window;
	}
}