/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 */
package com.thalesgroup.marte.rsa.helper.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Model;

import com.ibm.xtools.uml.navigator.ModelServerElement;
import com.thalesgroup.marte.rsa.helper.profileApplication.MarteProfileApplication;

/**
 * Apply all MARTE profile on a selected model (from RSA UML Treeview)
 * 
 * @author T0081227 Francois NIZOU - 18 oct. 07
 * 
 */
public class ApplyMarteProfileAction implements IObjectActionDelegate {

	/**
	 * Constructor for Action1.
	 */
	public ApplyMarteProfileAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow();
		ISelection selectedElement = activeWorkbenchWindow
				.getSelectionService().getSelection();

		IStructuredSelection structuredSel = (IStructuredSelection) selectedElement;
		ModelServerElement modelServerElement = (ModelServerElement) structuredSel
				.getFirstElement();
		Model model = (Model) modelServerElement.getElement();
		MarteProfileApplication.getInstance().applyMarteProfile(model);

	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

}
