/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 */
package com.thalesgroup.marte.rsa.helper.observationDecorator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget.Direction;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;

/**
 * The decorator for DurationObservation on Message.
 * 
 * @author T0081227 Francois NIZOU - 26 oct. 07
 * 
 */

public class DurationObservationDecorator1 implements IDecoratorProvider {

	public void createDecorators(IDecoratorTarget decoratorTarget) {

		Object eclass = decoratorTarget.getAdapter(EObject.class);
		Object view = decoratorTarget.getAdapter(View.class);

		// get the uml element and the gef notation element from adapter
		// to assert the decoratorTarget is a Message (the line, not the label)
		if (eclass instanceof Message && view instanceof Edge) {

			Event send = null;
			Event receive = null;

			// compute the send event
			Message msg = (Message) eclass;
			MessageEnd msgEnd = msg.getSendEvent();
			if (msgEnd instanceof MessageOccurrenceSpecification) {
				MessageOccurrenceSpecification mos = (MessageOccurrenceSpecification) msgEnd;
				send = mos.getEvent();
				if (send == null)
					return;
			}

			// compute the receive event
			msgEnd = msg.getReceiveEvent();
			if (msgEnd instanceof MessageOccurrenceSpecification) {
				MessageOccurrenceSpecification mos = (MessageOccurrenceSpecification) msgEnd;
				receive = mos.getEvent();
				if (receive == null)
					return;
			}

			// find out if a duration observation point on those two
			DurationObservation dObs = ObsFinder.getDurationObsForEvent(send,
					receive);

			if (dObs != null) {
				// decorate if that's the case
				IDecoration deco = decoratorTarget.addShapeDecoration(ImageUtil
						.drawDurationImage(dObs.getName()), Direction.SOUTH,
						-10, false);
			}

		}

	}

	public void addProviderChangeListener(IProviderChangeListener listener) {

	}

	public boolean provides(IOperation operation) {
		return true;
	}

	public void removeProviderChangeListener(IProviderChangeListener listener) {

	}
}
