/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 */
package com.thalesgroup.marte.rsa.helper.observationDecorator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget.Direction;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.OccurrenceSpecification;

/**
 * The decorator for DurationObseration on BehaviorExecutionSpecification
 * 
 * @author T0081227 Francois Nizou
 * 
 */
public class DurationObservationDecorator2 implements IDecoratorProvider {

	public void createDecorators(IDecoratorTarget decoratorTarget) {

		Object eclass = decoratorTarget.getAdapter(EObject.class);
		Object view = decoratorTarget.getAdapter(View.class);

		// get the uml element and the gef notation element
		// and assert the decoratorTarget represent a BehaviorExecSpecif
		// barre on life line.
		if (eclass instanceof BehaviorExecutionSpecification
				&& view instanceof Node) {

			Event start = null;
			Event end = null;

			// compute starting event and end event.
			BehaviorExecutionSpecification exec = (BehaviorExecutionSpecification) eclass;
			OccurrenceSpecification startOS = exec.getStart();
			OccurrenceSpecification finishOS = exec.getFinish();

			start = startOS.getEvent();
			end = finishOS.getEvent();

			if (start == null || end == null)
				return;
			DurationObservation dObs = ObsFinder.getDurationObsForEvent(start,
					end);

			// if a DurationObs point on those two, we decorate
			if (dObs != null) {
				IDecoration deco = decoratorTarget.addShapeDecoration(ImageUtil
						.drawDurationImage(dObs.getName()), Direction.EAST, 0,
						false);
			}
		}

	}

	public void addProviderChangeListener(IProviderChangeListener listener) {

	}

	public boolean provides(IOperation operation) {
		return true;
	}

	public void removeProviderChangeListener(IProviderChangeListener listener) {

	}

}
