/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 */
package com.thalesgroup.marte.rsa.helper.observationDecorator;

import java.net.URL;
import java.util.HashMap;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

import com.thalesgroup.marte.rsa.helper.Activator;

/**
 * Utility class to draw Decoration Image.
 * 
 * @author T0081227 Francois NIZOU - 18 oct. 07
 * 
 */
public class ImageUtil {

	// the blue color of the text
	private static final RGB RGB = new RGB(51, 95, 210);

	/**
	 * Draw an image for TimeObservation decoration
	 * 
	 * @param name
	 *            the name of the observation to draw
	 * @return an Image that is a rectangle composed of the TimeObs icon and the
	 *         name
	 */
	public static Image drawTimeImage(String name) {
		String label = name;
		Display display = PlatformUI.getWorkbench().getDisplay();
		Font font = new Font(display, "Tahoma", 10, SWT.NORMAL);
		Image image = new Image(display, 16 + (8 * label.length()), 15);
		GC gc = getTimeImage();
		gc.copyArea(image, 0, 0);
		gc = new GC(image);
		gc.setForeground(new Color(display, RGB));
		gc.setFont(font);
		gc.drawText(label, 16, 0, true);
		font.dispose();
		gc.dispose();
		return image;
	}

	/**
	 * Draw an image for DurationObservation decoration
	 * 
	 * @param name
	 *            the name of the observation to draw
	 * @return an Image that is a rectangle composed of the DurObs icon and the
	 *         name
	 */
	public static Image drawDurationImage(String name) {
		String label = name;
		Display display = PlatformUI.getWorkbench().getDisplay();
		Font font = new Font(display, "Tahoma", 10, SWT.NORMAL);
		Image image = new Image(display, 16 + (7 * label.length()), 15);
		GC gc = getDurationImage();
		gc.copyArea(image, 0, 0);
		gc = new GC(image);
		gc.setFont(font);
		gc.setForeground(new Color(display, RGB));
		gc.drawText(label, 16, 0, true);
		font.dispose();
		gc.dispose();
		return image;
	}

	/**
	 * unused for now. draw a stereotype name on top of another image
	 * 
	 * @param img
	 *            an image from drawDurationImage or drawTimeImage
	 * @param name
	 *            the name of the stereotype
	 * @return a new image
	 */
	public static Image drawStereotype(Image img, String name) {
		name = "<<" + name + ">>";
		Display display = PlatformUI.getWorkbench().getDisplay();
		Font font = new Font(display, "Tahoma", 7, SWT.ITALIC);
		int width = (img.getBounds().width > 5 * name.length()) ? img
				.getBounds().width : 5 * name.length();
		Image image = new Image(display, width, 30);

		GC gc = new GC(image);
		gc.setFont(font);
		gc.setForeground(new Color(display, RGB));
		gc.drawText(name, 0, 0, true);
		gc.drawImage(img, 0, 12);
		font.dispose();
		gc.dispose();

		// An attempt to ge transparency (not working)
		int whitePixel = image.getImageData().palette.getPixel(new RGB(255,
				255, 255));
		image.getImageData().transparentPixel = whitePixel;
		Image transparentImg = new Image(display, image.getImageData());

		return image;
	}

	/**
	 * compute (one time and only once) the Image from the icon of DurationObs
	 * 
	 * @param
	 */
	public static GC getDurationImage() {
		if (timeImage == null) {
			Path path = new Path("Images/DurationObservation.bmp");
			HashMap map = new HashMap();
			URL fileURL = FileLocator.find(Activator.getDefault().getBundle(),
					path, map);
			Image img = ImageDescriptor.createFromURL(fileURL).createImage();
			timeImage = new GC(img);
		}
		return timeImage;
	}

	/**
	 * compute (one time and only once) the Image from the icon of TimeObs
	 * 
	 * @param
	 */
	public static GC getTimeImage() {
		if (durationImage == null) {
			Path path = new Path("Images/TimeObservation.bmp");
			HashMap map = new HashMap();
			URL fileURL = FileLocator.find(Activator.getDefault().getBundle(),
					path, map);
			Image img = ImageDescriptor.createFromURL(fileURL).createImage();
			durationImage = new GC(img);
		}
		return durationImage;
	}

	private static GC timeImage = null;

	private static GC durationImage = null;

}
