/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright> 
 */

package com.thalesgroup.marte.rsa.helper.observationDecorator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.TimeObservation;

/**
 * Class that fetch every Observator in the model.
 * 
 * @author T0081227 Francois NIZOU - 18 oct. 07
 * 
 */
public class ObsFinder {

	/**
	 * Search into the model of the UML Event e an observation such as
	 * observation.getEvent().equals(e) == true
	 * @param e an event
	 * @return any TimeObservation watching an event
	 */
	public static TimeObservation getTimeObsForEvent(Event e) {
		Model model = e.getModel(); 
		EList packagedElements = model.allOwnedElements();
		for (Object object : packagedElements) {
			if (object instanceof TimeObservation) {
				TimeObservation obs = (TimeObservation) object;
				NamedElement event = obs.getEvent();
				if (event == null)
					continue;
				if (event.equals(e))
					return obs;
			}
		}
		return null;
	}

	/**
	 * Search into the models of e1 (assumes that is the same as the e2 one) a
	 * DurationObservation such as
	 * obs.getEvents().get(0) == e1 && obs.getEvents().get(1) == e2
	 * Or
	 * obs.getEvents().get(0) == e2 && obs.getEvents().get(1) == e1
	 * @param e1 an event
	 * @param e2 an event
	 * @return a durationObservation watching the 2 events
	 */
	public static DurationObservation getDurationObsForEvent(Event e1, Event e2) {
		Model model = e1.getModel();
		EList packagedElements = model.allOwnedElements();
		for (Object object : packagedElements) {
			if (!(object instanceof DurationObservation))
				continue;

			DurationObservation obs = (DurationObservation) object;
			EList events = obs.getEvents();
			if (events.size() == 2) {
				if (events.get(0).equals(e1) && events.get(1).equals(e2))
					return obs;
				if (events.get(0).equals(e2) && events.get(1).equals(e1))
					return obs;
			}
		}
		return null;

	}
}
