/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 */
package com.thalesgroup.marte.rsa.helper.observationDecorator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.DemultiplexingListener;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.UMLPackage;

/**
 * This class is a model Listener, using the extension point
 * org.eclipse.emf.transaction.listeners. This listener watch on Observation
 * (both kind) are modified) but does nothing right now.
 * 
 * @author T0081227 Francois NIZOU - 18 oct. 07
 * 
 */
public class ObsListeners extends DemultiplexingListener {

	public ObsListeners() {
		// This is where we can filter more notification sources.
		// Here we listen every change on Obseration.
		super(
				NotificationFilter
						.createNotifierTypeFilter(
								UMLPackage.Literals.DURATION_OBSERVATION)
						.or(
								NotificationFilter
										.createNotifierTypeFilter(UMLPackage.Literals.TIME_OBSERVATION))

		);
	}

	@Override
	protected void handleNotification(TransactionalEditingDomain domain,
			Notification notification) {

		Display display = PlatformUI.getWorkbench().getDisplay();
		display.timerExec(1, new Runnable() {
			public void run() {
				try {
					// This is where the system should force a redecoration.
					// I was unable to find out how without messing with SWT.

				} catch (Throwable t) {
					System.out.println("ObsListeners.handleNotification()");
				}
			}
		});
	}
	// default:
	// break;
	// }
	// }
}
