/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 */
package com.thalesgroup.marte.rsa.helper.observationDecorator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget.Direction;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.TimeObservation;

/**
 * Decorator for TImeObservation on Message.
 * 
 * @author T0081227 Francois NIZOU - 18 oct. 07
 * 
 */
public class TimeObservationDecorator implements IDecoratorProvider {

	public void createDecorators(IDecoratorTarget decoratorTarget) {
		Object eclass = decoratorTarget.getAdapter(EObject.class);
		Object view = decoratorTarget.getAdapter(View.class);

		if (eclass instanceof Message && view instanceof Edge) {

			Message msg = (Message) eclass;
			MessageEnd msgEnd = msg.getSendEvent();
			if (msgEnd instanceof MessageOccurrenceSpecification) {
				MessageOccurrenceSpecification mos = (MessageOccurrenceSpecification) msgEnd;
				Event event = mos.getEvent();
				TimeObservation to = ObsFinder.getTimeObsForEvent(event);
				if (to != null) {

					Image img = ImageUtil.drawTimeImage(to.getName());

					EList appliedStereotypes = to.getAppliedStereotypes();

					if (appliedStereotypes.size() > 0) {
						String sname = ((Stereotype) appliedStereotypes.get(0))
								.getName();
						// img = ImageUtil.drawStereotype(img, sname);
					}
					IDecoration deco = decoratorTarget.addShapeDecoration(img,
							Direction.SOUTH_WEST, -5, false);
					// DecoratedStuff.getInstance().addDeco(decoratorTarget,
					// deco);
					// new DecorationDuo(decoratorTarget, deco);
				}
			}

			;
			msgEnd = msg.getReceiveEvent();
			if (msgEnd instanceof MessageOccurrenceSpecification) {
				MessageOccurrenceSpecification mos = (MessageOccurrenceSpecification) msgEnd;
				Event event = mos.getEvent();
				TimeObservation to = ObsFinder.getTimeObsForEvent(event);
				if (to != null) {
					Image img = ImageUtil.drawTimeImage(to.getName());

					EList appliedStereotypes = to.getAppliedStereotypes();

					if (appliedStereotypes.size() > 0) {
						String sname = ((Stereotype) appliedStereotypes.get(0))
								.getName();
						// img = ImageUtil.drawStereotype(img, sname);
					}
					IDecoration deco = decoratorTarget.addShapeDecoration(img,
							Direction.EAST, 0, false);
					// new DecorationDuo(decoratorTarget, deco);
				}
			}
		}

	}

	public void addProviderChangeListener(IProviderChangeListener listener) {
	}

	public boolean provides(IOperation operation) {
		return true;
	}

	public void removeProviderChangeListener(IProviderChangeListener listener) {

	}

}
