/**
 * <copyright>
 * Thales MARTE (Copyright (c) THALES 2007 All rights reserved) is free software; you can redistribute itand/or modify
 * it under the terms of the Eclipse Public License as published in http://www.eclipse.org/legal/epl-v10.html
 
 * Thales MARTE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Eclipse Public License for more details. 
 * </copyright>
 */
package com.thalesgroup.marte.rsa.helper.profileApplication;

import java.util.List;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.uml2.uml.Profile;

import com.ibm.xtools.modeler.ui.UMLModeler;
import com.ibm.xtools.uml.msl.internal.util.UML2ResourceManager;
import com.ibm.xtools.uml.msl.internal.util.UML2ResourceManager.ProfileDescriptor;

/**
 * This class is a singleton used to apply all Marte profile on an UML Model
 * 
 * @author T0081227 Francois NIZOU - 18 oct. 07
 * 
 */
public class MarteProfileApplication {

	protected static MarteProfileApplication self;

	private MarteProfileApplication() {
	};

	/**
	 * 
	 * @return the singleton instance
	 */
	public static MarteProfileApplication getInstance() {
		if (self == null)
			MarteProfileApplication.self = new MarteProfileApplication();
		return self;
	}

	/**
	 * This methoid apply Marte model but it does need to be in an RSA
	 * transaction.
	 * 
	 * @param model
	 */
	public void transacApplyMarteProfile(org.eclipse.uml2.uml.Model model) {

		// 1. We load profile. Considering they're called MARTE_*

		List profileDescriptors = UML2ResourceManager.getProfileDescriptors();
		for (Object object : profileDescriptors) {
			ProfileDescriptor profileDescriptor = (ProfileDescriptor) object;
			if (!profileDescriptor.getName().startsWith("MARTE_"))
				continue;

			Profile profile = profileDescriptor.getProfile();
			if (model.getAppliedProfile(profile.getQualifiedName()) == null)
				model.applyProfile(profile);
		}
	}

	/**
	 * this method call transacApplyMarteProfile in a transaction
	 * 
	 * @param model
	 */
	public void applyMarteProfile(final org.eclipse.uml2.uml.Model model) {
		try {

			TransactionalEditingDomain editDomain = UMLModeler
					.getEditingDomain();
			editDomain.getCommandStack().execute(
					new RecordingCommand(editDomain) {
						protected void doExecute() {
							transacApplyMarteProfile(model);
						}
					});
		} catch (IllegalStateException e) {
			System.err.println("The operation was interrupted");
		}
	}
}
