/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FontMetrics;
import java.util.Vector;

public class TextScanner {
    private int charCount;
    private int lineWidth;
    private char[] cText;
    private int nLines;
    private Vector lines;
    private FontMetrics fm;

    TextScanner(String text, int lineWidth, FontMetrics fm) {
        this.lineWidth = lineWidth;
        this.fm = fm;
        this.setText(text);
    }

    private void addLine(int lineStart, int lineEnd) {
        ++this.nLines;
        this.lines.addElement(new String(this.cText, lineStart, lineEnd - lineStart + 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void breakLine(int lineStart, int lEnd) throws CantBreakLineException {
        boolean leadingSpace = true;
        int lineEnd = lEnd;
        while ((this.cText[lineEnd] == ' ' || this.cText[lineEnd] == '\t') && lineEnd > lineStart) {
            --lineEnd;
        }
        int curPos = lineStart;
        int prevBreak = lineStart - 1;
        int prevSpace = lineStart - 1;
        while (curPos <= lineEnd) {
            char aChar = this.cText[curPos];
            if (aChar == ' ' || aChar == '\t' || curPos == lineEnd) {
                if (curPos == lineEnd) {
                    ++curPos;
                    leadingSpace = false;
                }
                if (!leadingSpace) {
                    int tEnd = curPos - 1;
                    int tStart = prevBreak + 1;
                    int width = this.fm.charsWidth(this.cText, prevBreak + 1, tEnd - tStart + 1);
                    if (width >= this.lineWidth || curPos > lineEnd) {
                        if (width >= this.lineWidth) {
                            if (prevSpace >= lineStart) {
                                this.addLine(prevBreak + 1, prevSpace - 1);
                                prevBreak = prevSpace;
                                prevSpace = lineStart - 1;
                                if (--curPos == lineEnd) {
                                    --curPos;
                                }
                            } else {
                                int accWidth = 0;
                                int accStart = prevBreak + 1;
                                int accPos = prevBreak;
                                while (accWidth < this.lineWidth) {
                                    accWidth += this.fm.charWidth(this.cText[++accPos]);
                                }
                                if (--accPos < accStart) throw new CantBreakLineException();
                                this.addLine(accStart, accPos);
                                prevSpace = lineStart - 1;
                                prevBreak = accPos;
                                if (--curPos == lineEnd) {
                                    --curPos;
                                }
                            }
                        } else {
                            this.addLine(tStart, tEnd);
                            prevBreak = curPos;
                            prevSpace = lineStart - 1;
                        }
                    } else {
                        prevSpace = curPos;
                    }
                }
            } else {
                leadingSpace = false;
            }
            ++curPos;
        }
    }

    private void breakText() throws CantBreakLineException {
        this.nLines = 0;
        this.lines = new Vector();
        int curPos = 0;
        int textEnd = this.charCount - 1;
        int prevBreak = -1;
        while (curPos <= textEnd) {
            if (this.cText[curPos] == '\r' || this.cText[curPos] == '\n' || curPos == textEnd) {
                int lineEnd;
                int lineLength;
                int lineStart;
                int width;
                if (curPos == textEnd) {
                    ++curPos;
                }
                if ((width = this.fm.charsWidth(this.cText, lineStart = prevBreak + 1, lineLength = (lineEnd = curPos - 1) - lineStart + 1)) <= this.lineWidth) {
                    this.addLine(lineStart, lineEnd);
                } else {
                    this.breakLine(lineStart, lineEnd);
                }
                if (curPos >= textEnd || this.cText[curPos] != '\r' || this.cText[curPos + 1] == '\n') {
                    // empty if block
                }
                prevBreak = ++curPos;
            }
            ++curPos;
        }
    }

    private void clear() {
        this.charCount = 0;
        this.nLines = 0;
        this.lines = null;
        this.cText = null;
    }

    public String getLineAt(int index) {
        if (index >= 0 && index < this.nLines) {
            return (String)this.lines.elementAt(index);
        }
        return null;
    }

    public Vector getLines() {
        return this.lines;
    }

    public int getNumberOfLines() {
        return this.nLines;
    }

    private void reBreak() {
        block2: {
            if (this.charCount <= 0) break block2;
            try {
                this.breakText();
            }
            catch (CantBreakLineException cantBreakLineException) {
                this.nLines = 0;
                this.lines = null;
            }
        }
    }

    public void setFontMetrics(FontMetrics fm) {
        this.fm = fm;
        this.reBreak();
    }

    public void setLineWidth(int lineWidth) {
        if (this.lineWidth != lineWidth) {
            this.lineWidth = lineWidth;
            this.reBreak();
        }
    }

    public void setText(String text) {
        if (text != null) {
            this.charCount = text.length();
            if (this.charCount > 0) {
                this.cText = new char[this.charCount];
                int cEnd = this.charCount - 1;
                text.getChars(0, this.charCount, this.cText, 0);
                char aChar = this.cText[cEnd];
                while ((this.cText[cEnd] == ' ' || this.cText[cEnd] == '\t') && this.charCount > 0) {
                    --cEnd;
                    --this.charCount;
                }
                this.reBreak();
            } else {
                this.clear();
            }
        } else {
            this.clear();
        }
    }
}

