/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class TreeNode {
    TreeNode sibling;
    TreeNode child;
    TreeNode parent;
    URL urlHTML;
    URL urlDocumentation;
    URL urlContents;
    String baseDirectory;
    String text;
    String documentation;
    Image image;
    int depth = -1;
    boolean isExpanded = false;
    boolean contentsLoaded = false;
    boolean documentationLoaded = false;
    int numberOfChildren;
    private Utilities utils;

    public TreeNode(String string, Image image, URL uRL, URL uRL2, URL uRL3, String string2) {
        this.text = string;
        this.sibling = null;
        this.child = null;
        this.image = image;
        this.urlHTML = uRL;
        this.urlDocumentation = uRL2;
        this.urlContents = uRL3;
        this.numberOfChildren = 0;
        this.baseDirectory = string2;
    }

    void setDepth(int n) {
        this.depth = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public boolean isExpandable() {
        return this.child != null || this.urlContents != null;
    }

    public void expand(TreeView treeView) {
        if (this.isExpandable()) {
            if (this.urlContents != null && !this.contentsLoaded) {
                InputStream inputStream;
                try {
                    inputStream = this.urlContents.openStream();
                }
                catch (IOException iOException) {
                    System.out.println("Error opening connection to " + this.urlContents.toString());
                    return;
                }
                try {
                    this.parseContents(treeView, this, new LineInputStream(inputStream));
                }
                catch (IOException iOException) {
                    System.out.println("Error parsing contents file " + this.urlContents.toString());
                    return;
                }
                this.contentsLoaded = true;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    System.out.println("Error closing contents file " + this.urlContents.toString());
                }
            }
            this.isExpanded = true;
        }
    }

    public void collapse() {
        this.isExpanded = false;
    }

    public void toggle(TreeView treeView) {
        if (this.isExpanded) {
            this.collapse();
        } else if (this.isExpandable()) {
            this.expand(treeView);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public String getText() {
        return this.text;
    }

    public String getDocumentation() {
        if (!this.documentationLoaded) {
            this.documentation = "";
            if (this.urlDocumentation != null) {
                InputStream inputStream;
                try {
                    inputStream = this.urlDocumentation.openStream();
                }
                catch (IOException iOException) {
                    return "Error opening connection to " + this.urlDocumentation.toString();
                }
                try {
                    this.documentation = Utilities.readInputStreamAsString(inputStream);
                    if (this.documentation.length() == 0) {
                        this.documentation = "No documentation available";
                    }
                }
                catch (IOException iOException) {
                    return "Error reading documentation file " + this.urlDocumentation.toString();
                }
                this.documentationLoaded = true;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            } else {
                this.documentationLoaded = true;
                this.documentation = "No documentation available";
            }
        }
        return this.documentation;
    }

    public URL getUrlHTML() {
        return this.urlHTML;
    }

    public URL getUrlDocumentation() {
        return this.urlDocumentation;
    }

    public URL getUrlContents() {
        return this.urlContents;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    private void parseContents(TreeView treeView, TreeNode treeNode, LineInputStream lineInputStream) throws IOException {
        TreeNode treeNode2 = treeNode;
        while (!lineInputStream.eof()) {
            String string;
            String string2;
            String string3 = lineInputStream.readLine().trim();
            if (string3.equals("(")) {
                this.parseContents(treeView, treeNode2, lineInputStream);
                continue;
            }
            if (string3.equals(")")) {
                return;
            }
            URL uRL = treeView.getApplet().getCodeBase();
            String string4 = string3;
            String string5 = lineInputStream.readLine().trim();
            URL uRL2 = Utilities.makeURL(uRL, Utilities.addBase(this.baseDirectory, string5));
            String string6 = lineInputStream.readLine().trim();
            URL uRL3 = null;
            if (string6.length() > 0) {
                string2 = string6;
                string2.toLowerCase();
                uRL3 = string2.startsWith("http:") || string2.startsWith("ftp:") || string2.startsWith("news:") || string2.startsWith("mailto:") || string2.startsWith("file:") ? new URL(Utilities.encode(string6)) : Utilities.makeURL(uRL, Utilities.addBase(this.baseDirectory, string6));
            }
            string2 = lineInputStream.readLine().trim();
            URL uRL4 = null;
            if (string2.length() > 0) {
                uRL4 = Utilities.makeURL(uRL, Utilities.addBase(this.baseDirectory, string2));
            }
            String string7 = lineInputStream.readLine().trim();
            URL uRL5 = null;
            if (string7.length() > 0) {
                uRL5 = Utilities.makeURL(uRL, Utilities.addBase(this.baseDirectory, string7));
            }
            if ((string = lineInputStream.readLine().trim()).length() > 0) {
                string = Utilities.addBase(this.baseDirectory, string);
            }
            Image image = treeView.getImage(uRL2);
            treeNode2 = new TreeNode(string4, image, uRL3, uRL4, uRL5, string);
            treeView.insert(treeNode2, treeNode, 0);
        }
    }
}

